/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class CoreFoundation {
    public static final long kCFAllocatorDefault;
    public static final long kCFAllocatorSystemDefault;
    public static final long kCFAllocatorMalloc;
    public static final long kCFAllocatorMallocZone;
    public static final long kCFAllocatorNull;
    public static final long kCFAllocatorUseContext;

    private static native long kCFAllocatorDefault();

    private static native long kCFAllocatorSystemDefault();

    private static native long kCFAllocatorMalloc();

    private static native long kCFAllocatorMallocZone();

    private static native long kCFAllocatorNull();

    private static native long kCFAllocatorUseContext();

    public static native void nCFRelease(long var0);

    public static void CFRelease(long cf) {
        if (Checks.CHECKS) {
            Checks.check(cf);
        }
        CoreFoundation.nCFRelease(cf);
    }

    public static native long nCFBundleCreate(long var0, long var2);

    public static long CFBundleCreate(long allocator, long bundleURL) {
        if (Checks.CHECKS) {
            Checks.check(bundleURL);
        }
        return CoreFoundation.nCFBundleCreate(allocator, bundleURL);
    }

    public static native long nCFBundleGetFunctionPointerForName(long var0, long var2);

    public static long CFBundleGetFunctionPointerForName(long bundle, long functionName) {
        if (Checks.CHECKS) {
            Checks.check(bundle);
            Checks.check(functionName);
        }
        return CoreFoundation.nCFBundleGetFunctionPointerForName(bundle, functionName);
    }

    public static native long nCFStringCreateWithCStringNoCopy(long var0, long var2, int var4, long var5);

    public static long CFStringCreateWithCStringNoCopy(long allocator, ByteBuffer cStr, int encoding, long contentsDeallocator) {
        return CoreFoundation.nCFStringCreateWithCStringNoCopy(allocator, MemoryUtil.memAddress(cStr), encoding, contentsDeallocator);
    }

    public static native long nCFURLCreateWithFileSystemPath(long var0, long var2, long var4, boolean var6);

    public static long CFURLCreateWithFileSystemPath(long allocator, long filePath, long pathStyle, boolean isDirectory) {
        if (Checks.CHECKS) {
            Checks.check(filePath);
        }
        return CoreFoundation.nCFURLCreateWithFileSystemPath(allocator, filePath, pathStyle, isDirectory);
    }

    static {
        Library.initialize();
        kCFAllocatorDefault = CoreFoundation.kCFAllocatorDefault();
        kCFAllocatorSystemDefault = CoreFoundation.kCFAllocatorSystemDefault();
        kCFAllocatorMalloc = CoreFoundation.kCFAllocatorMalloc();
        kCFAllocatorMallocZone = CoreFoundation.kCFAllocatorMallocZone();
        kCFAllocatorNull = CoreFoundation.kCFAllocatorNull();
        kCFAllocatorUseContext = CoreFoundation.kCFAllocatorUseContext();
    }
}

