/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BoneLocal;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.IkConstraintPose;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PathConstraintPose;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.PhysicsConstraintPose;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SliderData;
import com.esotericsoftware.spine.SliderPose;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.TransformConstraintPose;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class SkeletonJson
extends SkeletonLoader {
    private final Array<LinkedMesh> linkedMeshes = new Array(true, 8, LinkedMesh[]::new);

    public SkeletonJson(TextureAtlas textureAtlas) {
        super(textureAtlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        try {
            SkeletonData skeletonData = this.readSkeletonData(new JsonReader().parse(fileHandle));
            skeletonData.name = fileHandle.nameWithoutExtension();
            return skeletonData;
        }
        catch (Throwable throwable) {
            throw new SerializationException("Error reading JSON skeleton file: " + fileHandle, throwable);
        }
    }

    public SkeletonData readSkeletonData(JsonValue jsonValue) {
        if (jsonValue == null) {
            throw new IllegalArgumentException("root cannot be null.");
        }
        SkeletonData skeletonData = new SkeletonData();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            Object object5;
            float f = this.scale;
            JsonValue jsonValue2 = jsonValue.get("skeleton");
            if (jsonValue2 != null) {
                skeletonData.hash = jsonValue2.getString("hash", null);
                skeletonData.version = jsonValue2.getString("spine", null);
                skeletonData.x = jsonValue2.getFloat("x", 0.0f);
                skeletonData.y = jsonValue2.getFloat("y", 0.0f);
                skeletonData.width = jsonValue2.getFloat("width", 0.0f);
                skeletonData.height = jsonValue2.getFloat("height", 0.0f);
                skeletonData.referenceScale = jsonValue2.getFloat("referenceScale", 100.0f) * f;
                skeletonData.fps = jsonValue2.getFloat("fps", 30.0f);
                skeletonData.imagesPath = jsonValue2.getString("images", null);
                skeletonData.audioPath = jsonValue2.getString("audio", null);
            }
            Object object6 = jsonValue.getChild("bones");
            while (object6 != null) {
                object5 = null;
                string = ((JsonValue)object6).getString("parent", null);
                if (string != null && (object5 = skeletonData.findBone(string)) == null) {
                    throw new SerializationException("Parent bone not found: " + string);
                }
                object4 = new BoneData(skeletonData.bones.size, ((JsonValue)object6).getString("name"), (BoneData)object5);
                ((BoneData)object4).length = ((JsonValue)object6).getFloat("length", 0.0f) * f;
                object3 = (BoneLocal)((BoneData)object4).setup;
                ((BoneLocal)object3).x = ((JsonValue)object6).getFloat("x", 0.0f) * f;
                ((BoneLocal)object3).y = ((JsonValue)object6).getFloat("y", 0.0f) * f;
                ((BoneLocal)object3).rotation = ((JsonValue)object6).getFloat("rotation", 0.0f);
                ((BoneLocal)object3).scaleX = ((JsonValue)object6).getFloat("scaleX", 1.0f);
                ((BoneLocal)object3).scaleY = ((JsonValue)object6).getFloat("scaleY", 1.0f);
                ((BoneLocal)object3).shearX = ((JsonValue)object6).getFloat("shearX", 0.0f);
                ((BoneLocal)object3).shearY = ((JsonValue)object6).getFloat("shearY", 0.0f);
                ((BoneLocal)object3).inherit = BoneData.Inherit.valueOf(((JsonValue)object6).getString("inherit", BoneData.Inherit.normal.name()));
                ((BoneData)object4).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
                object2 = ((JsonValue)object6).getString("color", null);
                if (object2 != null) {
                    Color.valueOf((String)object2, ((BoneData)object4).getColor());
                }
                ((BoneData)object4).icon = ((JsonValue)object6).getString("icon", null);
                ((BoneData)object4).visible = ((JsonValue)object6).getBoolean("visible", true);
                skeletonData.bones.add((BoneData)object4);
                object6 = ((JsonValue)object6).next;
            }
            object6 = jsonValue.getChild("slots");
            while (object6 != null) {
                object5 = ((JsonValue)object6).getString("name");
                string = ((JsonValue)object6).getString("bone");
                object4 = skeletonData.findBone(string);
                if (object4 == null) {
                    throw new SerializationException("Slot bone not found: " + string);
                }
                object3 = new SlotData(skeletonData.slots.size, (String)object5, (BoneData)object4);
                object2 = ((JsonValue)object6).getString("color", null);
                if (object2 != null) {
                    Color.valueOf((String)object2, ((SlotPose)((SlotData)object3).setup).getColor());
                }
                if ((object = ((JsonValue)object6).getString("dark", null)) != null) {
                    ((SlotPose)((SlotData)object3).setup).darkColor = Color.valueOf((String)object);
                }
                ((SlotData)object3).attachmentName = ((JsonValue)object6).getString("attachment", null);
                ((SlotData)object3).blendMode = BlendMode.valueOf(((JsonValue)object6).getString("blend", BlendMode.normal.name()));
                ((SlotData)object3).visible = ((JsonValue)object6).getBoolean("visible", true);
                skeletonData.slots.add((SlotData)object3);
                object6 = ((JsonValue)object6).next;
            }
            object6 = jsonValue.getChild("constraints");
            while (object6 != null) {
                object5 = ((JsonValue)object6).getString("name");
                boolean bl = ((JsonValue)object6).getBoolean("skin", false);
                switch (((JsonValue)object6).getString("type")) {
                    case "ik": {
                        Object object7;
                        object2 = new IkConstraintData((String)object5);
                        ((IkConstraintData)object2).skinRequired = bl;
                        object = ((JsonValue)object6).getChild("bones");
                        while (object != null) {
                            object7 = skeletonData.findBone(((JsonValue)object).asString());
                            if (object7 == null) {
                                throw new SerializationException("IK bone not found: " + (JsonValue)object);
                            }
                            ((IkConstraintData)object2).bones.add((BoneData)object7);
                            object = ((JsonValue)object).next;
                        }
                        object = ((JsonValue)object6).getString("target");
                        ((IkConstraintData)object2).target = skeletonData.findBone((String)object);
                        if (((IkConstraintData)object2).target == null) {
                            throw new SerializationException("IK target bone not found: " + (String)object);
                        }
                        ((IkConstraintData)object2).uniform = ((JsonValue)object6).getBoolean("uniform", false);
                        object7 = (IkConstraintPose)((IkConstraintData)object2).setup;
                        ((IkConstraintPose)object7).mix = ((JsonValue)object6).getFloat("mix", 1.0f);
                        ((IkConstraintPose)object7).softness = ((JsonValue)object6).getFloat("softness", 0.0f) * f;
                        ((IkConstraintPose)object7).bendDirection = ((JsonValue)object6).getBoolean("bendPositive", true) ? 1 : -1;
                        ((IkConstraintPose)object7).compress = ((JsonValue)object6).getBoolean("compress", false);
                        ((IkConstraintPose)object7).stretch = ((JsonValue)object6).getBoolean("stretch", false);
                        skeletonData.constraints.add((ConstraintData)object2);
                        break;
                    }
                    case "transform": {
                        object2 = new TransformConstraintData((String)object5);
                        ((TransformConstraintData)object2).skinRequired = bl;
                        object = ((JsonValue)object6).getChild("bones");
                        while (object != null) {
                            BoneData boneData = skeletonData.findBone(((JsonValue)object).asString());
                            if (boneData == null) {
                                throw new SerializationException("Transform constraint bone not found: " + (JsonValue)object);
                            }
                            ((TransformConstraintData)object2).bones.add(boneData);
                            object = ((JsonValue)object).next;
                        }
                        object = ((JsonValue)object6).getString("source");
                        ((TransformConstraintData)object2).source = skeletonData.findBone((String)object);
                        if (((TransformConstraintData)object2).source == null) {
                            throw new SerializationException("Transform constraint source bone not found: " + (String)object);
                        }
                        ((TransformConstraintData)object2).localSource = ((JsonValue)object6).getBoolean("localSource", false);
                        ((TransformConstraintData)object2).localTarget = ((JsonValue)object6).getBoolean("localTarget", false);
                        ((TransformConstraintData)object2).additive = ((JsonValue)object6).getBoolean("additive", false);
                        ((TransformConstraintData)object2).clamp = ((JsonValue)object6).getBoolean("clamp", false);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        Object object8 = ((JsonValue)object6).getChild("properties");
                        while (object8 != null) {
                            TransformConstraintData.FromProperty fromProperty = this.fromProperty(((JsonValue)object8).name);
                            float f2 = this.propertyScale(((JsonValue)object8).name, f);
                            fromProperty.offset = ((JsonValue)object8).getFloat("offset", 0.0f) * f2;
                            JsonValue jsonValue3 = ((JsonValue)object8).getChild("to");
                            while (jsonValue3 != null) {
                                TransformConstraintData.ToProperty toProperty;
                                float f3 = 1.0f;
                                switch (jsonValue3.name) {
                                    case "rotate": {
                                        bl2 = true;
                                        toProperty = new TransformConstraintData.ToRotate();
                                        break;
                                    }
                                    case "x": {
                                        bl3 = true;
                                        toProperty = new TransformConstraintData.ToX();
                                        f3 = f;
                                        break;
                                    }
                                    case "y": {
                                        bl4 = true;
                                        toProperty = new TransformConstraintData.ToY();
                                        f3 = f;
                                        break;
                                    }
                                    case "scaleX": {
                                        bl5 = true;
                                        toProperty = new TransformConstraintData.ToScaleX();
                                        break;
                                    }
                                    case "scaleY": {
                                        bl6 = true;
                                        toProperty = new TransformConstraintData.ToScaleY();
                                        break;
                                    }
                                    case "shearY": {
                                        bl7 = true;
                                        toProperty = new TransformConstraintData.ToShearY();
                                        break;
                                    }
                                    default: {
                                        throw new SerializationException("Invalid transform constraint to property: " + jsonValue3.name);
                                    }
                                }
                                toProperty.offset = jsonValue3.getFloat("offset", 0.0f) * f3;
                                toProperty.max = jsonValue3.getFloat("max", 1.0f) * f3;
                                toProperty.scale = jsonValue3.getFloat("scale", 1.0f) * f3 / f2;
                                fromProperty.to.add(toProperty);
                                jsonValue3 = jsonValue3.next;
                            }
                            if (fromProperty.to.notEmpty()) {
                                ((TransformConstraintData)object2).properties.add(fromProperty);
                            }
                            object8 = ((JsonValue)object8).next;
                        }
                        ((TransformConstraintData)object2).offsets[0] = ((JsonValue)object6).getFloat("rotation", 0.0f);
                        ((TransformConstraintData)object2).offsets[1] = ((JsonValue)object6).getFloat("x", 0.0f) * f;
                        ((TransformConstraintData)object2).offsets[2] = ((JsonValue)object6).getFloat("y", 0.0f) * f;
                        ((TransformConstraintData)object2).offsets[3] = ((JsonValue)object6).getFloat("scaleX", 0.0f);
                        ((TransformConstraintData)object2).offsets[4] = ((JsonValue)object6).getFloat("scaleY", 0.0f);
                        ((TransformConstraintData)object2).offsets[5] = ((JsonValue)object6).getFloat("shearY", 0.0f);
                        object8 = (TransformConstraintPose)((TransformConstraintData)object2).setup;
                        if (bl2) {
                            ((TransformConstraintPose)object8).mixRotate = ((JsonValue)object6).getFloat("mixRotate", 1.0f);
                        }
                        if (bl3) {
                            ((TransformConstraintPose)object8).mixX = ((JsonValue)object6).getFloat("mixX", 1.0f);
                        }
                        if (bl4) {
                            ((TransformConstraintPose)object8).mixY = ((JsonValue)object6).getFloat("mixY", ((TransformConstraintPose)object8).mixX);
                        }
                        if (bl5) {
                            ((TransformConstraintPose)object8).mixScaleX = ((JsonValue)object6).getFloat("mixScaleX", 1.0f);
                        }
                        if (bl6) {
                            ((TransformConstraintPose)object8).mixScaleY = ((JsonValue)object6).getFloat("mixScaleY", ((TransformConstraintPose)object8).mixScaleX);
                        }
                        if (bl7) {
                            ((TransformConstraintPose)object8).mixShearY = ((JsonValue)object6).getFloat("mixShearY", 1.0f);
                        }
                        skeletonData.constraints.add((ConstraintData)object2);
                        break;
                    }
                    case "path": {
                        object2 = new PathConstraintData((String)object5);
                        ((PathConstraintData)object2).skinRequired = bl;
                        object = ((JsonValue)object6).getChild("bones");
                        while (object != null) {
                            BoneData boneData = skeletonData.findBone(((JsonValue)object).asString());
                            if (boneData == null) {
                                throw new SerializationException("Path bone not found: " + (JsonValue)object);
                            }
                            ((PathConstraintData)object2).bones.add(boneData);
                            object = ((JsonValue)object).next;
                        }
                        object = ((JsonValue)object6).getString("slot");
                        ((PathConstraintData)object2).slot = skeletonData.findSlot((String)object);
                        if (((PathConstraintData)object2).slot == null) {
                            throw new SerializationException("Path slot not found: " + (String)object);
                        }
                        ((PathConstraintData)object2).positionMode = PathConstraintData.PositionMode.valueOf(((JsonValue)object6).getString("positionMode", "percent"));
                        ((PathConstraintData)object2).spacingMode = PathConstraintData.SpacingMode.valueOf(((JsonValue)object6).getString("spacingMode", "length"));
                        ((PathConstraintData)object2).rotateMode = PathConstraintData.RotateMode.valueOf(((JsonValue)object6).getString("rotateMode", "tangent"));
                        ((PathConstraintData)object2).offsetRotation = ((JsonValue)object6).getFloat("rotation", 0.0f);
                        PathConstraintPose pathConstraintPose = (PathConstraintPose)((PathConstraintData)object2).setup;
                        pathConstraintPose.position = ((JsonValue)object6).getFloat("position", 0.0f);
                        if (((PathConstraintData)object2).positionMode == PathConstraintData.PositionMode.fixed) {
                            pathConstraintPose.position *= f;
                        }
                        pathConstraintPose.spacing = ((JsonValue)object6).getFloat("spacing", 0.0f);
                        if (((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.fixed) {
                            pathConstraintPose.spacing *= f;
                        }
                        pathConstraintPose.mixRotate = ((JsonValue)object6).getFloat("mixRotate", 1.0f);
                        pathConstraintPose.mixX = ((JsonValue)object6).getFloat("mixX", 1.0f);
                        pathConstraintPose.mixY = ((JsonValue)object6).getFloat("mixY", pathConstraintPose.mixX);
                        skeletonData.constraints.add((ConstraintData)object2);
                        break;
                    }
                    case "physics": {
                        object2 = new PhysicsConstraintData((String)object5);
                        ((PhysicsConstraintData)object2).skinRequired = bl;
                        object = ((JsonValue)object6).getString("bone");
                        ((PhysicsConstraintData)object2).bone = skeletonData.findBone((String)object);
                        if (((PhysicsConstraintData)object2).bone == null) {
                            throw new SerializationException("Physics bone not found: " + (String)object);
                        }
                        ((PhysicsConstraintData)object2).x = ((JsonValue)object6).getFloat("x", 0.0f);
                        ((PhysicsConstraintData)object2).y = ((JsonValue)object6).getFloat("y", 0.0f);
                        ((PhysicsConstraintData)object2).rotate = ((JsonValue)object6).getFloat("rotate", 0.0f);
                        ((PhysicsConstraintData)object2).scaleX = ((JsonValue)object6).getFloat("scaleX", 0.0f);
                        ((PhysicsConstraintData)object2).shearX = ((JsonValue)object6).getFloat("shearX", 0.0f);
                        ((PhysicsConstraintData)object2).limit = ((JsonValue)object6).getFloat("limit", 5000.0f) * f;
                        ((PhysicsConstraintData)object2).step = 1.0f / (float)((JsonValue)object6).getInt("fps", 60);
                        PhysicsConstraintPose physicsConstraintPose = (PhysicsConstraintPose)((PhysicsConstraintData)object2).setup;
                        physicsConstraintPose.inertia = ((JsonValue)object6).getFloat("inertia", 0.5f);
                        physicsConstraintPose.strength = ((JsonValue)object6).getFloat("strength", 100.0f);
                        physicsConstraintPose.damping = ((JsonValue)object6).getFloat("damping", 0.85f);
                        physicsConstraintPose.massInverse = 1.0f / ((JsonValue)object6).getFloat("mass", 1.0f);
                        physicsConstraintPose.wind = ((JsonValue)object6).getFloat("wind", 0.0f);
                        physicsConstraintPose.gravity = ((JsonValue)object6).getFloat("gravity", 0.0f);
                        physicsConstraintPose.mix = ((JsonValue)object6).getFloat("mix", 1.0f);
                        ((PhysicsConstraintData)object2).inertiaGlobal = ((JsonValue)object6).getBoolean("inertiaGlobal", false);
                        ((PhysicsConstraintData)object2).strengthGlobal = ((JsonValue)object6).getBoolean("strengthGlobal", false);
                        ((PhysicsConstraintData)object2).dampingGlobal = ((JsonValue)object6).getBoolean("dampingGlobal", false);
                        ((PhysicsConstraintData)object2).massGlobal = ((JsonValue)object6).getBoolean("massGlobal", false);
                        ((PhysicsConstraintData)object2).windGlobal = ((JsonValue)object6).getBoolean("windGlobal", false);
                        ((PhysicsConstraintData)object2).gravityGlobal = ((JsonValue)object6).getBoolean("gravityGlobal", false);
                        ((PhysicsConstraintData)object2).mixGlobal = ((JsonValue)object6).getBoolean("mixGlobal", false);
                        skeletonData.constraints.add((ConstraintData)object2);
                        break;
                    }
                    case "slider": {
                        object2 = new SliderData((String)object5);
                        ((SliderData)object2).skinRequired = bl;
                        ((SliderData)object2).additive = ((JsonValue)object6).getBoolean("additive", false);
                        ((SliderData)object2).loop = ((JsonValue)object6).getBoolean("loop", false);
                        ((SliderPose)((SliderData)object2).setup).time = ((JsonValue)object6).getFloat("time", 0.0f);
                        ((SliderPose)((SliderData)object2).setup).mix = ((JsonValue)object6).getFloat("mix", 1.0f);
                        object = ((JsonValue)object6).getString("bone", null);
                        if (object != null) {
                            ((SliderData)object2).bone = skeletonData.findBone((String)object);
                            if (((SliderData)object2).bone == null) {
                                throw new SerializationException("Slider bone not found: " + (String)object);
                            }
                            String string2 = ((JsonValue)object6).getString("property");
                            ((SliderData)object2).property = this.fromProperty(string2);
                            float f4 = this.propertyScale(string2, f);
                            ((SliderData)object2).property.offset = ((JsonValue)object6).getFloat("from", 0.0f) * f4;
                            ((SliderData)object2).offset = ((JsonValue)object6).getFloat("to", 0.0f);
                            ((SliderData)object2).scale = ((JsonValue)object6).getFloat("scale", 1.0f) / f4;
                            ((SliderData)object2).local = ((JsonValue)object6).getBoolean("local", false);
                        }
                        skeletonData.constraints.add((ConstraintData)object2);
                    }
                }
                object6 = ((JsonValue)object6).next;
            }
            object6 = jsonValue.getChild("skins");
            while (object6 != null) {
                object5 = new Skin(((JsonValue)object6).getString("name"));
                Object object9 = ((JsonValue)object6).getChild("bones");
                while (object9 != null) {
                    object4 = skeletonData.findBone(((JsonValue)object9).asString());
                    if (object4 == null) {
                        throw new SerializationException("Skin bone not found: " + (JsonValue)object9);
                    }
                    ((Skin)object5).bones.add((BoneData)object4);
                    object9 = ((JsonValue)object9).next;
                }
                ((Skin)object5).bones.shrink();
                object9 = ((JsonValue)object6).getChild("ik");
                while (object9 != null) {
                    object4 = skeletonData.findConstraint(((JsonValue)object9).asString(), IkConstraintData.class);
                    if (object4 == null) {
                        throw new SerializationException("Skin IK constraint not found: " + (JsonValue)object9);
                    }
                    ((Skin)object5).constraints.add((ConstraintData)object4);
                    object9 = ((JsonValue)object9).next;
                }
                object9 = ((JsonValue)object6).getChild("transform");
                while (object9 != null) {
                    object4 = skeletonData.findConstraint(((JsonValue)object9).asString(), TransformConstraintData.class);
                    if (object4 == null) {
                        throw new SerializationException("Skin transform constraint not found: " + (JsonValue)object9);
                    }
                    ((Skin)object5).constraints.add((ConstraintData)object4);
                    object9 = ((JsonValue)object9).next;
                }
                object9 = ((JsonValue)object6).getChild("path");
                while (object9 != null) {
                    object4 = skeletonData.findConstraint(((JsonValue)object9).asString(), PathConstraintData.class);
                    if (object4 == null) {
                        throw new SerializationException("Skin path constraint not found: " + (JsonValue)object9);
                    }
                    ((Skin)object5).constraints.add((ConstraintData)object4);
                    object9 = ((JsonValue)object9).next;
                }
                object9 = ((JsonValue)object6).getChild("physics");
                while (object9 != null) {
                    object4 = skeletonData.findConstraint(((JsonValue)object9).asString(), PhysicsConstraintData.class);
                    if (object4 == null) {
                        throw new SerializationException("Skin physics constraint not found: " + (JsonValue)object9);
                    }
                    ((Skin)object5).constraints.add((ConstraintData)object4);
                    object9 = ((JsonValue)object9).next;
                }
                object9 = ((JsonValue)object6).getChild("slider");
                while (object9 != null) {
                    object4 = skeletonData.findConstraint(((JsonValue)object9).asString(), SliderData.class);
                    if (object4 == null) {
                        throw new SerializationException("Skin slider not found: " + (JsonValue)object9);
                    }
                    ((Skin)object5).constraints.add((ConstraintData)object4);
                    object9 = ((JsonValue)object9).next;
                }
                ((Skin)object5).constraints.shrink();
                object9 = ((JsonValue)object6).getChild("attachments");
                while (object9 != null) {
                    object4 = skeletonData.findSlot(((JsonValue)object9).name);
                    if (object4 == null) {
                        throw new SerializationException("Slot not found: " + ((JsonValue)object9).name);
                    }
                    JsonValue jsonValue4 = ((JsonValue)object9).child;
                    while (jsonValue4 != null) {
                        try {
                            object2 = this.readAttachment(jsonValue4, (Skin)object5, ((SlotData)object4).index, jsonValue4.name, skeletonData);
                            if (object2 != null) {
                                ((Skin)object5).setAttachment(((SlotData)object4).index, jsonValue4.name, (Attachment)object2);
                            }
                        }
                        catch (Throwable throwable) {
                            throw new SerializationException("Error reading attachment: " + jsonValue4.name + ", skin: " + (Skin)object5, throwable);
                        }
                        jsonValue4 = jsonValue4.next;
                    }
                    object9 = ((JsonValue)object9).next;
                }
                object9 = ((JsonValue)object6).getString("color", null);
                if (object9 != null) {
                    Color.valueOf((String)object9, ((Skin)object5).getColor());
                }
                skeletonData.skins.add((Skin)object5);
                if (((Skin)object5).name.equals("default")) {
                    skeletonData.defaultSkin = object5;
                }
                object6 = ((JsonValue)object6).next;
            }
            object6 = (LinkedMesh[])this.linkedMeshes.items;
            int n = this.linkedMeshes.size;
            for (int i = 0; i < n; ++i) {
                Skin skin;
                object4 = object6[i];
                Skin skin2 = skin = ((LinkedMesh)object4).skin == null ? skeletonData.defaultSkin : skeletonData.findSkin(((LinkedMesh)object4).skin);
                if (skin == null) {
                    throw new SerializationException("Skin not found: " + ((LinkedMesh)object4).skin);
                }
                object2 = skin.getAttachment(((LinkedMesh)object4).slotIndex, ((LinkedMesh)object4).parent);
                if (object2 == null) {
                    throw new SerializationException("Parent mesh not found: " + ((LinkedMesh)object4).parent);
                }
                ((LinkedMesh)object4).mesh.setTimelineAttachment(((LinkedMesh)object4).inheritTimelines ? (VertexAttachment)object2 : ((LinkedMesh)object4).mesh);
                ((LinkedMesh)object4).mesh.setParentMesh((MeshAttachment)object2);
                if (((LinkedMesh)object4).mesh.getRegion() == null) continue;
                ((LinkedMesh)object4).mesh.updateRegion();
            }
            this.linkedMeshes.clear();
            JsonValue jsonValue5 = jsonValue.getChild("events");
            while (jsonValue5 != null) {
                EventData eventData = new EventData(jsonValue5.name);
                eventData.intValue = jsonValue5.getInt("int", 0);
                eventData.floatValue = jsonValue5.getFloat("float", 0.0f);
                eventData.stringValue = jsonValue5.getString("string", "");
                eventData.audioPath = jsonValue5.getString("audio", null);
                if (eventData.audioPath != null) {
                    eventData.volume = jsonValue5.getFloat("volume", 1.0f);
                    eventData.balance = jsonValue5.getFloat("balance", 0.0f);
                }
                skeletonData.events.add(eventData);
                jsonValue5 = jsonValue5.next;
            }
            jsonValue5 = jsonValue.getChild("animations");
            while (jsonValue5 != null) {
                try {
                    this.readAnimation(jsonValue5, jsonValue5.name, skeletonData);
                }
                catch (Throwable throwable) {
                    throw new SerializationException("Error reading animation: " + jsonValue5.name, throwable);
                }
                jsonValue5 = jsonValue5.next;
            }
            jsonValue5 = jsonValue.getChild("constraints");
            while (jsonValue5 != null) {
                if (jsonValue5.getString("type").equals("slider")) {
                    SliderData sliderData = skeletonData.findConstraint(jsonValue5.getString("name"), SliderData.class);
                    object4 = jsonValue5.getString("animation");
                    sliderData.animation = skeletonData.findAnimation((String)object4);
                    if (sliderData.animation == null) {
                        throw new SerializationException("Slider animation not found: " + (String)object4);
                    }
                }
                jsonValue5 = jsonValue5.next;
            }
            skeletonData.bones.shrink();
            skeletonData.slots.shrink();
            skeletonData.skins.shrink();
            skeletonData.events.shrink();
            skeletonData.animations.shrink();
            skeletonData.constraints.shrink();
            return skeletonData;
        }
        catch (Throwable throwable) {
            if (skeletonData.version != null) {
                throw new SerializationException("Error reading JSON skeleton data, version: " + skeletonData.version, throwable);
            }
            throw new SerializationException("Error JSON skeleton data.", throwable);
        }
    }

    private TransformConstraintData.FromProperty fromProperty(String string) {
        return switch (string) {
            case "rotate" -> new TransformConstraintData.FromRotate();
            case "x" -> new TransformConstraintData.FromX();
            case "y" -> new TransformConstraintData.FromY();
            case "scaleX" -> new TransformConstraintData.FromScaleX();
            case "scaleY" -> new TransformConstraintData.FromScaleY();
            case "shearY" -> new TransformConstraintData.FromShearY();
            default -> throw new SerializationException("Invalid from property: " + string);
        };
    }

    private float propertyScale(String string, float f) {
        return switch (string) {
            case "x", "y" -> f;
            default -> 1.0f;
        };
    }

    private Attachment readAttachment(JsonValue jsonValue, Skin skin, int n, String string, SkeletonData skeletonData) {
        float f = this.scale;
        string = jsonValue.getString("name", string);
        return switch (AttachmentType.valueOf(jsonValue.getString("type", AttachmentType.region.name()))) {
            case AttachmentType.region -> {
                String var7_7 = jsonValue.getString("path", string);
                Sequence var8_13 = this.readSequence(jsonValue.get("sequence"));
                RegionAttachment var9_19 = this.attachmentLoader.newRegionAttachment(skin, string, var7_7, var8_13);
                if (var9_19 == null) {
                    yield null;
                }
                var9_19.setPath(var7_7);
                var9_19.setX(jsonValue.getFloat("x", 0.0f) * f);
                var9_19.setY(jsonValue.getFloat("y", 0.0f) * f);
                var9_19.setScaleX(jsonValue.getFloat("scaleX", 1.0f));
                var9_19.setScaleY(jsonValue.getFloat("scaleY", 1.0f));
                var9_19.setRotation(jsonValue.getFloat("rotation", 0.0f));
                var9_19.setWidth(jsonValue.getFloat("width") * f);
                var9_19.setHeight(jsonValue.getFloat("height") * f);
                var9_19.setSequence(var8_13);
                String var10_23 = jsonValue.getString("color", null);
                if (var10_23 != null) {
                    Color.valueOf(var10_23, var9_19.getColor());
                }
                if (var9_19.getRegion() != null) {
                    var9_19.updateRegion();
                }
                yield var9_19;
            }
            case AttachmentType.boundingbox -> {
                BoundingBoxAttachment var7_8 = this.attachmentLoader.newBoundingBoxAttachment(skin, string);
                if (var7_8 == null) {
                    yield null;
                }
                this.readVertices(jsonValue, var7_8, jsonValue.getInt("vertexCount") << 1);
                String var8_14 = jsonValue.getString("color", null);
                if (var8_14 != null) {
                    Color.valueOf(var8_14, var7_8.getColor());
                }
                yield var7_8;
            }
            case AttachmentType.mesh, AttachmentType.linkedmesh -> {
                String var7_9 = jsonValue.getString("path", string);
                Sequence var8_15 = this.readSequence(jsonValue.get("sequence"));
                MeshAttachment var9_20 = this.attachmentLoader.newMeshAttachment(skin, string, var7_9, var8_15);
                if (var9_20 == null) {
                    yield null;
                }
                var9_20.setPath(var7_9);
                String var10_24 = jsonValue.getString("color", null);
                if (var10_24 != null) {
                    Color.valueOf(var10_24, var9_20.getColor());
                }
                var9_20.setWidth(jsonValue.getFloat("width", 0.0f) * f);
                var9_20.setHeight(jsonValue.getFloat("height", 0.0f) * f);
                var9_20.setSequence(var8_15);
                String var11_26 = jsonValue.getString("parent", null);
                if (var11_26 != null) {
                    this.linkedMeshes.add(new LinkedMesh(var9_20, jsonValue.getString("skin", null), n, var11_26, jsonValue.getBoolean("timelines", true)));
                    yield var9_20;
                }
                float[] var12_28 = jsonValue.require("uvs").asFloatArray();
                this.readVertices(jsonValue, var9_20, var12_28.length);
                var9_20.setTriangles(jsonValue.require("triangles").asShortArray());
                var9_20.setRegionUVs(var12_28);
                if (var9_20.getRegion() != null) {
                    var9_20.updateRegion();
                }
                if (jsonValue.has("hull")) {
                    var9_20.setHullLength(jsonValue.require("hull").asInt() << 1);
                }
                if (jsonValue.has("edges")) {
                    var9_20.setEdges(jsonValue.require("edges").asShortArray());
                }
                yield var9_20;
            }
            case AttachmentType.path -> {
                PathAttachment var7_10 = this.attachmentLoader.newPathAttachment(skin, string);
                if (var7_10 == null) {
                    yield null;
                }
                var7_10.setClosed(jsonValue.getBoolean("closed", false));
                var7_10.setConstantSpeed(jsonValue.getBoolean("constantSpeed", true));
                int var8_16 = jsonValue.getInt("vertexCount");
                this.readVertices(jsonValue, var7_10, var8_16 << 1);
                float[] var9_21 = new float[var8_16 / 3];
                int var10_25 = 0;
                Object var11_27 = jsonValue.require((String)"lengths").child;
                while (var11_27 != null) {
                    var9_21[var10_25++] = ((JsonValue)var11_27).asFloat() * f;
                    var11_27 = ((JsonValue)var11_27).next;
                }
                var7_10.setLengths(var9_21);
                var11_27 = jsonValue.getString("color", null);
                if (var11_27 != null) {
                    Color.valueOf((String)var11_27, var7_10.getColor());
                }
                yield var7_10;
            }
            case AttachmentType.point -> {
                PointAttachment var7_11 = this.attachmentLoader.newPointAttachment(skin, string);
                if (var7_11 == null) {
                    yield null;
                }
                var7_11.setX(jsonValue.getFloat("x", 0.0f) * f);
                var7_11.setY(jsonValue.getFloat("y", 0.0f) * f);
                var7_11.setRotation(jsonValue.getFloat("rotation", 0.0f));
                String var8_17 = jsonValue.getString("color", null);
                if (var8_17 != null) {
                    Color.valueOf(var8_17, var7_11.getColor());
                }
                yield var7_11;
            }
            case AttachmentType.clipping -> {
                Object var9_22;
                ClippingAttachment var7_12 = this.attachmentLoader.newClippingAttachment(skin, string);
                if (var7_12 == null) {
                    yield null;
                }
                String var8_18 = jsonValue.getString("end", null);
                if (var8_18 != null) {
                    var9_22 = skeletonData.findSlot(var8_18);
                    if (var9_22 == null) {
                        throw new SerializationException("Clipping end slot not found: " + var8_18);
                    }
                    var7_12.setEndSlot((SlotData)var9_22);
                }
                this.readVertices(jsonValue, var7_12, jsonValue.getInt("vertexCount") << 1);
                var9_22 = jsonValue.getString("color", null);
                if (var9_22 != null) {
                    Color.valueOf((String)var9_22, var7_12.getColor());
                }
                yield var7_12;
            }
            default -> null;
        };
    }

    private Sequence readSequence(JsonValue jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        Sequence sequence = new Sequence(jsonValue.getInt("count"));
        sequence.setStart(jsonValue.getInt("start", 1));
        sequence.setDigits(jsonValue.getInt("digits", 0));
        sequence.setSetupIndex(jsonValue.getInt("setup", 0));
        return sequence;
    }

    private void readVertices(JsonValue jsonValue, VertexAttachment vertexAttachment, int n) {
        vertexAttachment.setWorldVerticesLength(n);
        float[] fArray = jsonValue.require("vertices").asFloatArray();
        if (n == fArray.length) {
            if (this.scale != 1.0f) {
                int n2 = 0;
                int n3 = fArray.length;
                while (n2 < n3) {
                    int n4 = n2++;
                    fArray[n4] = fArray[n4] * this.scale;
                }
            }
            vertexAttachment.setVertices(fArray);
            return;
        }
        FloatArray floatArray = new FloatArray(n * 3 * 3);
        IntArray intArray = new IntArray(n * 3);
        int n5 = 0;
        int n6 = fArray.length;
        while (n5 < n6) {
            int n7 = (int)fArray[n5++];
            intArray.add(n7);
            int n8 = n5 + (n7 << 2);
            while (n5 < n8) {
                intArray.add((int)fArray[n5]);
                floatArray.add(fArray[n5 + 1] * this.scale);
                floatArray.add(fArray[n5 + 2] * this.scale);
                floatArray.add(fArray[n5 + 3]);
                n5 += 4;
            }
        }
        vertexAttachment.setBones(intArray.toArray());
        vertexAttachment.setVertices(floatArray.toArray());
    }

    private void readAnimation(JsonValue jsonValue, String string, SkeletonData skeletonData) {
        JsonValue jsonValue2;
        float f;
        float f2;
        float f3;
        float f4;
        Object object;
        int n;
        Animation.Timeline timeline;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        float f5 = this.scale;
        Array<Animation.Timeline> array = new Array<Animation.Timeline>(true, 16, Animation.Timeline[]::new);
        JsonValue jsonValue3 = jsonValue.getChild("slots");
        while (jsonValue3 != null) {
            object4 = skeletonData.findSlot(jsonValue3.name);
            if (object4 == null) {
                throw new SerializationException("Slot not found: " + jsonValue3.name);
            }
            object3 = jsonValue3.child;
            while (object3 != null) {
                object2 = ((JsonValue)object3).child;
                if (object2 != null) {
                    n2 = ((JsonValue)object3).size;
                    switch (((JsonValue)object3).name) {
                        case "attachment": {
                            timeline = new Animation.AttachmentTimeline(n2, ((SlotData)object4).index);
                            n = 0;
                            while (object2 != null) {
                                ((Animation.AttachmentTimeline)timeline).setFrame(n, ((JsonValue)object2).getFloat("time", 0.0f), ((JsonValue)object2).getString("name", null));
                                object2 = ((JsonValue)object2).next;
                                ++n;
                            }
                            array.add(timeline);
                            break;
                        }
                        case "rgba": {
                            float f6;
                            timeline = new Animation.RGBATimeline(n2, n2 << 2, ((SlotData)object4).index);
                            float f7 = ((JsonValue)object2).getFloat("time", 0.0f);
                            object = ((JsonValue)object2).getString("color");
                            f4 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                            f3 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                            f2 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                            float f8 = (float)Integer.parseInt(((String)object).substring(6, 8), 16) / 255.0f;
                            int n3 = 0;
                            int n4 = 0;
                            while (true) {
                                ((Animation.RGBATimeline)timeline).setFrame(n3, f7, f4, f3, f2, f8);
                                JsonValue jsonValue4 = ((JsonValue)object2).next;
                                if (jsonValue4 == null) break;
                                float f9 = jsonValue4.getFloat("time", 0.0f);
                                object = jsonValue4.getString("color");
                                float f10 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                                float f11 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                                f = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                                f6 = (float)Integer.parseInt(((String)object).substring(6, 8), 16) / 255.0f;
                                JsonValue jsonValue5 = ((JsonValue)object2).get("curve");
                                if (jsonValue5 != null) {
                                    n4 = this.readCurve(jsonValue5, (Animation.CurveTimeline)timeline, n4, n3, 0, f7, f9, f4, f10, 1.0f);
                                    n4 = this.readCurve(jsonValue5, (Animation.CurveTimeline)timeline, n4, n3, 1, f7, f9, f3, f11, 1.0f);
                                    n4 = this.readCurve(jsonValue5, (Animation.CurveTimeline)timeline, n4, n3, 2, f7, f9, f2, f, 1.0f);
                                    n4 = this.readCurve(jsonValue5, (Animation.CurveTimeline)timeline, n4, n3, 3, f7, f9, f8, f6, 1.0f);
                                }
                                f7 = f9;
                                f4 = f10;
                                f3 = f11;
                                f2 = f;
                                f8 = f6;
                                object2 = jsonValue4;
                                ++n3;
                            }
                            ((Animation.CurveTimeline)timeline).shrink(n4);
                            array.add(timeline);
                            break;
                        }
                        case "rgb": {
                            timeline = new Animation.RGBTimeline(n2, n2 * 3, ((SlotData)object4).index);
                            float f12 = ((JsonValue)object2).getFloat("time", 0.0f);
                            object = ((JsonValue)object2).getString("color");
                            f4 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                            f3 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                            f2 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                            int n5 = 0;
                            int n6 = 0;
                            while (true) {
                                ((Animation.RGBTimeline)timeline).setFrame(n5, f12, f4, f3, f2);
                                JsonValue jsonValue6 = ((JsonValue)object2).next;
                                if (jsonValue6 == null) break;
                                float f13 = jsonValue6.getFloat("time", 0.0f);
                                object = jsonValue6.getString("color");
                                float f14 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                                float f15 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                                float f16 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                                JsonValue jsonValue7 = ((JsonValue)object2).get("curve");
                                if (jsonValue7 != null) {
                                    n6 = this.readCurve(jsonValue7, (Animation.CurveTimeline)timeline, n6, n5, 0, f12, f13, f4, f14, 1.0f);
                                    n6 = this.readCurve(jsonValue7, (Animation.CurveTimeline)timeline, n6, n5, 1, f12, f13, f3, f15, 1.0f);
                                    n6 = this.readCurve(jsonValue7, (Animation.CurveTimeline)timeline, n6, n5, 2, f12, f13, f2, f16, 1.0f);
                                }
                                f12 = f13;
                                f4 = f14;
                                f3 = f15;
                                f2 = f16;
                                object2 = jsonValue6;
                                ++n5;
                            }
                            ((Animation.CurveTimeline)timeline).shrink(n6);
                            array.add(timeline);
                            break;
                        }
                        case "alpha": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.AlphaTimeline(n2, n2, ((SlotData)object4).index), 0.0f, 1.0f);
                            break;
                        }
                        case "rgba2": {
                            float f17;
                            float f18;
                            float f19;
                            float f6;
                            timeline = new Animation.RGBA2Timeline(n2, n2 * 7, ((SlotData)object4).index);
                            float f20 = ((JsonValue)object2).getFloat("time", 0.0f);
                            object = ((JsonValue)object2).getString("light");
                            f4 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                            f3 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                            f2 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                            float f8 = (float)Integer.parseInt(((String)object).substring(6, 8), 16) / 255.0f;
                            object = ((JsonValue)object2).getString("dark");
                            float f21 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                            float f22 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                            float f23 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                            int n7 = 0;
                            int n8 = 0;
                            while (true) {
                                ((Animation.RGBA2Timeline)timeline).setFrame(n7, f20, f4, f3, f2, f8, f21, f22, f23);
                                JsonValue jsonValue8 = ((JsonValue)object2).next;
                                if (jsonValue8 == null) break;
                                f = jsonValue8.getFloat("time", 0.0f);
                                object = jsonValue8.getString("light");
                                f6 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                                float f24 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                                f19 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                                f18 = (float)Integer.parseInt(((String)object).substring(6, 8), 16) / 255.0f;
                                object = jsonValue8.getString("dark");
                                f17 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                                float f25 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                                float f26 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                                JsonValue jsonValue9 = ((JsonValue)object2).get("curve");
                                if (jsonValue9 != null) {
                                    n8 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n8, n7, 0, f20, f, f4, f6, 1.0f);
                                    n8 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n8, n7, 1, f20, f, f3, f24, 1.0f);
                                    n8 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n8, n7, 2, f20, f, f2, f19, 1.0f);
                                    n8 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n8, n7, 3, f20, f, f8, f18, 1.0f);
                                    n8 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n8, n7, 4, f20, f, f21, f17, 1.0f);
                                    n8 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n8, n7, 5, f20, f, f22, f25, 1.0f);
                                    n8 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n8, n7, 6, f20, f, f23, f26, 1.0f);
                                }
                                f20 = f;
                                f4 = f6;
                                f3 = f24;
                                f2 = f19;
                                f8 = f18;
                                f21 = f17;
                                f22 = f25;
                                f23 = f26;
                                object2 = jsonValue8;
                                ++n7;
                            }
                            ((Animation.CurveTimeline)timeline).shrink(n8);
                            array.add(timeline);
                            break;
                        }
                        case "rgb2": {
                            float f17;
                            float f18;
                            float f19;
                            float f6;
                            timeline = new Animation.RGB2Timeline(n2, n2 * 6, ((SlotData)object4).index);
                            float f27 = ((JsonValue)object2).getFloat("time", 0.0f);
                            object = ((JsonValue)object2).getString("light");
                            f4 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                            f3 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                            f2 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                            object = ((JsonValue)object2).getString("dark");
                            float f8 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                            float f28 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                            float f29 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                            int n9 = 0;
                            int n7 = 0;
                            while (true) {
                                ((Animation.RGB2Timeline)timeline).setFrame(n9, f27, f4, f3, f2, f8, f28, f29);
                                JsonValue jsonValue10 = ((JsonValue)object2).next;
                                if (jsonValue10 == null) break;
                                float f30 = jsonValue10.getFloat("time", 0.0f);
                                object = jsonValue10.getString("light");
                                f = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                                f6 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                                float f31 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                                object = jsonValue10.getString("dark");
                                f19 = (float)Integer.parseInt(((String)object).substring(0, 2), 16) / 255.0f;
                                f18 = (float)Integer.parseInt(((String)object).substring(2, 4), 16) / 255.0f;
                                f17 = (float)Integer.parseInt(((String)object).substring(4, 6), 16) / 255.0f;
                                JsonValue jsonValue11 = ((JsonValue)object2).get("curve");
                                if (jsonValue11 != null) {
                                    n7 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, n7, n9, 0, f27, f30, f4, f, 1.0f);
                                    n7 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, n7, n9, 1, f27, f30, f3, f6, 1.0f);
                                    n7 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, n7, n9, 2, f27, f30, f2, f31, 1.0f);
                                    n7 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, n7, n9, 3, f27, f30, f8, f19, 1.0f);
                                    n7 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, n7, n9, 4, f27, f30, f28, f18, 1.0f);
                                    n7 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, n7, n9, 5, f27, f30, f29, f17, 1.0f);
                                }
                                f27 = f30;
                                f4 = f;
                                f3 = f6;
                                f2 = f31;
                                f8 = f19;
                                f28 = f18;
                                f29 = f17;
                                object2 = jsonValue10;
                                ++n9;
                            }
                            ((Animation.CurveTimeline)timeline).shrink(n7);
                            array.add(timeline);
                        }
                    }
                }
                object3 = ((JsonValue)object3).next;
            }
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("bones");
        while (jsonValue3 != null) {
            object4 = skeletonData.findBone(jsonValue3.name);
            if (object4 == null) {
                throw new SerializationException("Bone not found: " + jsonValue3.name);
            }
            object3 = jsonValue3.child;
            while (object3 != null) {
                object2 = ((JsonValue)object3).child;
                if (object2 != null) {
                    n2 = ((JsonValue)object3).size;
                    switch (((JsonValue)object3).name) {
                        case "rotate": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.RotateTimeline(n2, n2, ((BoneData)object4).index), 0.0f, 1.0f);
                            break;
                        }
                        case "translate": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.TranslateTimeline(n2, n2 << 1, ((BoneData)object4).index), "x", "y", 0.0f, f5);
                            break;
                        }
                        case "translatex": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.TranslateXTimeline(n2, n2, ((BoneData)object4).index), 0.0f, f5);
                            break;
                        }
                        case "translatey": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.TranslateYTimeline(n2, n2, ((BoneData)object4).index), 0.0f, f5);
                            break;
                        }
                        case "scale": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.ScaleTimeline(n2, n2 << 1, ((BoneData)object4).index), "x", "y", 1.0f, 1.0f);
                            break;
                        }
                        case "scalex": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.ScaleXTimeline(n2, n2, ((BoneData)object4).index), 1.0f, 1.0f);
                            break;
                        }
                        case "scaley": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.ScaleYTimeline(n2, n2, ((BoneData)object4).index), 1.0f, 1.0f);
                            break;
                        }
                        case "shear": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.ShearTimeline(n2, n2 << 1, ((BoneData)object4).index), "x", "y", 0.0f, 1.0f);
                            break;
                        }
                        case "shearx": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.ShearXTimeline(n2, n2, ((BoneData)object4).index), 0.0f, 1.0f);
                            break;
                        }
                        case "sheary": {
                            this.readTimeline(array, (JsonValue)object2, new Animation.ShearYTimeline(n2, n2, ((BoneData)object4).index), 0.0f, 1.0f);
                            break;
                        }
                        case "inherit": {
                            timeline = new Animation.InheritTimeline(n2, ((BoneData)object4).index);
                            n = 0;
                            while (object2 != null) {
                                ((Animation.InheritTimeline)timeline).setFrame(n, ((JsonValue)object2).getFloat("time", 0.0f), BoneData.Inherit.valueOf(((JsonValue)object2).getString("inherit", BoneData.Inherit.normal.name())));
                                object2 = ((JsonValue)object2).next;
                                ++n;
                            }
                            array.add(timeline);
                        }
                    }
                }
                object3 = ((JsonValue)object3).next;
            }
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("ik");
        while (jsonValue3 != null) {
            object4 = jsonValue3.child;
            if (object4 != null) {
                object3 = skeletonData.findConstraint(jsonValue3.name, IkConstraintData.class);
                if (object3 == null) {
                    throw new SerializationException("IK constraint not found: " + jsonValue3.name);
                }
                object2 = new Animation.IkConstraintTimeline(jsonValue3.size, jsonValue3.size << 1, skeletonData.constraints.indexOf((ConstraintData)object3, true));
                float f32 = ((JsonValue)object4).getFloat("time", 0.0f);
                float f33 = ((JsonValue)object4).getFloat("mix", 1.0f);
                float f34 = ((JsonValue)object4).getFloat("softness", 0.0f) * f5;
                int n10 = 0;
                n = 0;
                while (true) {
                    ((Animation.IkConstraintTimeline)object2).setFrame(n10, f32, f33, f34, ((JsonValue)object4).getBoolean("bendPositive", true) ? 1 : -1, ((JsonValue)object4).getBoolean("compress", false), ((JsonValue)object4).getBoolean("stretch", false));
                    object = ((JsonValue)object4).next;
                    if (object == null) break;
                    f4 = ((JsonValue)object).getFloat("time", 0.0f);
                    f3 = ((JsonValue)object).getFloat("mix", 1.0f);
                    f2 = ((JsonValue)object).getFloat("softness", 0.0f) * f5;
                    JsonValue jsonValue12 = ((JsonValue)object4).get("curve");
                    if (jsonValue12 != null) {
                        n = this.readCurve(jsonValue12, (Animation.CurveTimeline)object2, n, n10, 0, f32, f4, f33, f3, 1.0f);
                        n = this.readCurve(jsonValue12, (Animation.CurveTimeline)object2, n, n10, 1, f32, f4, f34, f2, f5);
                    }
                    f32 = f4;
                    f33 = f3;
                    f34 = f2;
                    object4 = object;
                    ++n10;
                }
                ((Animation.CurveTimeline)object2).shrink(n);
                array.add((Animation.Timeline)object2);
            }
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("transform");
        while (jsonValue3 != null) {
            object4 = jsonValue3.child;
            if (object4 != null) {
                object3 = skeletonData.findConstraint(jsonValue3.name, TransformConstraintData.class);
                if (object3 == null) {
                    throw new SerializationException("Transform constraint not found: " + jsonValue3.name);
                }
                object2 = new Animation.TransformConstraintTimeline(jsonValue3.size, jsonValue3.size * 6, skeletonData.constraints.indexOf((ConstraintData)object3, true));
                float f35 = ((JsonValue)object4).getFloat("time", 0.0f);
                float f36 = ((JsonValue)object4).getFloat("mixRotate", 1.0f);
                float f37 = ((JsonValue)object4).getFloat("mixX", 1.0f);
                float f38 = ((JsonValue)object4).getFloat("mixY", f37);
                float f39 = ((JsonValue)object4).getFloat("mixScaleX", 1.0f);
                float f40 = ((JsonValue)object4).getFloat("mixScaleY", 1.0f);
                f4 = ((JsonValue)object4).getFloat("mixShearY", 1.0f);
                int n11 = 0;
                int n12 = 0;
                while (true) {
                    ((Animation.TransformConstraintTimeline)object2).setFrame(n11, f35, f36, f37, f38, f39, f40, f4);
                    JsonValue jsonValue13 = ((JsonValue)object4).next;
                    if (jsonValue13 == null) break;
                    float f41 = jsonValue13.getFloat("time", 0.0f);
                    float f42 = jsonValue13.getFloat("mixRotate", 1.0f);
                    float f43 = jsonValue13.getFloat("mixX", 1.0f);
                    float f44 = jsonValue13.getFloat("mixY", f43);
                    float f45 = jsonValue13.getFloat("mixScaleX", 1.0f);
                    float f46 = jsonValue13.getFloat("mixScaleY", 1.0f);
                    f = jsonValue13.getFloat("mixShearY", 1.0f);
                    JsonValue jsonValue14 = ((JsonValue)object4).get("curve");
                    if (jsonValue14 != null) {
                        n12 = this.readCurve(jsonValue14, (Animation.CurveTimeline)object2, n12, n11, 0, f35, f41, f36, f42, 1.0f);
                        n12 = this.readCurve(jsonValue14, (Animation.CurveTimeline)object2, n12, n11, 1, f35, f41, f37, f43, 1.0f);
                        n12 = this.readCurve(jsonValue14, (Animation.CurveTimeline)object2, n12, n11, 2, f35, f41, f38, f44, 1.0f);
                        n12 = this.readCurve(jsonValue14, (Animation.CurveTimeline)object2, n12, n11, 3, f35, f41, f39, f45, 1.0f);
                        n12 = this.readCurve(jsonValue14, (Animation.CurveTimeline)object2, n12, n11, 4, f35, f41, f40, f46, 1.0f);
                        n12 = this.readCurve(jsonValue14, (Animation.CurveTimeline)object2, n12, n11, 5, f35, f41, f4, f, 1.0f);
                    }
                    f35 = f41;
                    f36 = f42;
                    f37 = f43;
                    f38 = f44;
                    f39 = f45;
                    f40 = f46;
                    f4 = f;
                    object4 = jsonValue13;
                    ++n11;
                }
                ((Animation.CurveTimeline)object2).shrink(n12);
                array.add((Animation.Timeline)object2);
            }
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("path");
        while (jsonValue3 != null) {
            object4 = skeletonData.findConstraint(jsonValue3.name, PathConstraintData.class);
            if (object4 == null) {
                throw new SerializationException("Path constraint not found: " + jsonValue3.name);
            }
            int n13 = skeletonData.constraints.indexOf((ConstraintData)object4, true);
            object2 = jsonValue3.child;
            while (object2 != null) {
                JsonValue jsonValue15 = ((JsonValue)object2).child;
                if (jsonValue15 != null) {
                    int n14 = ((JsonValue)object2).size;
                    switch (((JsonValue)object2).name) {
                        case "position": {
                            Animation.CurveTimeline curveTimeline = new Animation.PathConstraintPositionTimeline(n14, n14, n13);
                            this.readTimeline(array, jsonValue15, (Animation.CurveTimeline1)curveTimeline, 0.0f, ((PathConstraintData)object4).positionMode == PathConstraintData.PositionMode.fixed ? f5 : 1.0f);
                            break;
                        }
                        case "spacing": {
                            Animation.CurveTimeline curveTimeline = new Animation.PathConstraintSpacingTimeline(n14, n14, n13);
                            this.readTimeline(array, jsonValue15, (Animation.CurveTimeline1)curveTimeline, 0.0f, ((PathConstraintData)object4).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object4).spacingMode == PathConstraintData.SpacingMode.fixed ? f5 : 1.0f);
                            break;
                        }
                        case "mix": {
                            Animation.CurveTimeline curveTimeline = new Animation.PathConstraintMixTimeline(n14, n14 * 3, n13);
                            float f47 = jsonValue15.getFloat("time", 0.0f);
                            f4 = jsonValue15.getFloat("mixRotate", 1.0f);
                            float f48 = jsonValue15.getFloat("mixX", 1.0f);
                            float f49 = jsonValue15.getFloat("mixY", f48);
                            int n15 = 0;
                            int n16 = 0;
                            while (true) {
                                ((Animation.PathConstraintMixTimeline)curveTimeline).setFrame(n15, f47, f4, f48, f49);
                                JsonValue jsonValue16 = jsonValue15.next;
                                if (jsonValue16 == null) break;
                                float f50 = jsonValue16.getFloat("time", 0.0f);
                                float f51 = jsonValue16.getFloat("mixRotate", 1.0f);
                                float f52 = jsonValue16.getFloat("mixX", 1.0f);
                                float f53 = jsonValue16.getFloat("mixY", f52);
                                JsonValue jsonValue17 = jsonValue15.get("curve");
                                if (jsonValue17 != null) {
                                    n16 = this.readCurve(jsonValue17, curveTimeline, n16, n15, 0, f47, f50, f4, f51, 1.0f);
                                    n16 = this.readCurve(jsonValue17, curveTimeline, n16, n15, 1, f47, f50, f48, f52, 1.0f);
                                    n16 = this.readCurve(jsonValue17, curveTimeline, n16, n15, 2, f47, f50, f49, f53, 1.0f);
                                }
                                f47 = f50;
                                f4 = f51;
                                f48 = f52;
                                f49 = f53;
                                jsonValue15 = jsonValue16;
                                ++n15;
                            }
                            curveTimeline.shrink(n16);
                            array.add(curveTimeline);
                        }
                    }
                }
                object2 = ((JsonValue)object2).next;
            }
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("physics");
        while (jsonValue3 != null) {
            Object object5;
            int n17 = -1;
            if (!jsonValue3.name.isEmpty()) {
                object5 = skeletonData.findConstraint(jsonValue3.name, PhysicsConstraintData.class);
                if (object5 == null) {
                    throw new SerializationException("Physics constraint not found: " + jsonValue3.name);
                }
                n17 = skeletonData.constraints.indexOf((ConstraintData)object5, true);
            }
            object5 = jsonValue3.child;
            while (object5 != null) {
                block162: {
                    object2 = ((JsonValue)object5).child;
                    if (object2 != null) {
                        Animation.PhysicsConstraintTimeline physicsConstraintTimeline;
                        int n18 = ((JsonValue)object5).size;
                        float f54 = 0.0f;
                        switch (((JsonValue)object5).name) {
                            case "reset": {
                                Animation.PhysicsConstraintResetTimeline physicsConstraintResetTimeline = new Animation.PhysicsConstraintResetTimeline(n18, n17);
                                int n19 = 0;
                                while (object2 != null) {
                                    physicsConstraintResetTimeline.setFrame(n19, ((JsonValue)object2).getFloat("time", 0.0f));
                                    object2 = ((JsonValue)object2).next;
                                    ++n19;
                                }
                                array.add(physicsConstraintResetTimeline);
                                break block162;
                            }
                            case "inertia": {
                                physicsConstraintTimeline = new Animation.PhysicsConstraintInertiaTimeline(n18, n18, n17);
                                break;
                            }
                            case "strength": {
                                physicsConstraintTimeline = new Animation.PhysicsConstraintStrengthTimeline(n18, n18, n17);
                                break;
                            }
                            case "damping": {
                                physicsConstraintTimeline = new Animation.PhysicsConstraintDampingTimeline(n18, n18, n17);
                                break;
                            }
                            case "mass": {
                                physicsConstraintTimeline = new Animation.PhysicsConstraintMassTimeline(n18, n18, n17);
                                break;
                            }
                            case "wind": {
                                physicsConstraintTimeline = new Animation.PhysicsConstraintWindTimeline(n18, n18, n17);
                                break;
                            }
                            case "gravity": {
                                physicsConstraintTimeline = new Animation.PhysicsConstraintGravityTimeline(n18, n18, n17);
                                break;
                            }
                            case "mix": {
                                f54 = 1.0f;
                                physicsConstraintTimeline = new Animation.PhysicsConstraintMixTimeline(n18, n18, n17);
                                break;
                            }
                            default: {
                                break block162;
                            }
                        }
                        this.readTimeline(array, (JsonValue)object2, physicsConstraintTimeline, f54, 1.0f);
                    }
                }
                object5 = ((JsonValue)object5).next;
            }
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("slider");
        while (jsonValue3 != null) {
            SliderData sliderData = skeletonData.findConstraint(jsonValue3.name, SliderData.class);
            if (sliderData == null) {
                throw new SerializationException("Slider not found: " + jsonValue3.name);
            }
            int n20 = skeletonData.constraints.indexOf(sliderData, true);
            object2 = jsonValue3.child;
            while (object2 != null) {
                JsonValue jsonValue18 = ((JsonValue)object2).child;
                if (jsonValue18 != null) {
                    int n21 = ((JsonValue)object2).size;
                    switch (((JsonValue)object2).name) {
                        case "time": {
                            this.readTimeline(array, jsonValue18, new Animation.SliderTimeline(n21, n21, n20), 1.0f, 1.0f);
                            break;
                        }
                        case "mix": {
                            this.readTimeline(array, jsonValue18, new Animation.SliderMixTimeline(n21, n21, n20), 1.0f, 1.0f);
                        }
                    }
                }
                object2 = ((JsonValue)object2).next;
            }
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("attachments");
        while (jsonValue3 != null) {
            Skin skin = skeletonData.findSkin(jsonValue3.name);
            if (skin == null) {
                throw new SerializationException("Skin not found: " + jsonValue3.name);
            }
            JsonValue jsonValue19 = jsonValue3.child;
            while (jsonValue19 != null) {
                object2 = skeletonData.findSlot(jsonValue19.name);
                if (object2 == null) {
                    throw new SerializationException("Slot not found: " + jsonValue19.name);
                }
                JsonValue jsonValue20 = jsonValue19.child;
                while (jsonValue20 != null) {
                    Attachment attachment = skin.getAttachment(((SlotData)object2).index, jsonValue20.name);
                    if (attachment == null) {
                        throw new SerializationException("Timeline attachment not found: " + jsonValue20.name);
                    }
                    JsonValue jsonValue21 = jsonValue20.child;
                    while (jsonValue21 != null) {
                        JsonValue jsonValue22 = jsonValue21.child;
                        int n22 = jsonValue21.size;
                        switch (jsonValue21.name) {
                            case "deform": {
                                Object object6 = (VertexAttachment)attachment;
                                boolean bl = ((VertexAttachment)object6).getBones() != null;
                                float[] fArray = ((VertexAttachment)object6).getVertices();
                                int n23 = bl ? fArray.length / 3 << 1 : fArray.length;
                                Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(n22, n22, ((SlotData)object2).index, (VertexAttachment)object6);
                                float f55 = jsonValue22.getFloat("time", 0.0f);
                                int n24 = 0;
                                int n25 = 0;
                                while (true) {
                                    float[] fArray2;
                                    JsonValue jsonValue23;
                                    if ((jsonValue23 = jsonValue22.get("vertices")) == null) {
                                        fArray2 = bl ? new float[n23] : fArray;
                                    } else {
                                        fArray2 = new float[n23];
                                        int n26 = jsonValue22.getInt("offset", 0);
                                        SpineUtils.arraycopy(jsonValue23.asFloatArray(), 0, fArray2, n26, jsonValue23.size);
                                        if (f5 != 1.0f) {
                                            int n27 = n26;
                                            int n28 = n27 + jsonValue23.size;
                                            while (n27 < n28) {
                                                int n29 = n27++;
                                                fArray2[n29] = fArray2[n29] * f5;
                                            }
                                        }
                                        if (!bl) {
                                            for (int i = 0; i < n23; ++i) {
                                                int n30 = i;
                                                fArray2[n30] = fArray2[n30] + fArray[i];
                                            }
                                        }
                                    }
                                    deformTimeline.setFrame(n24, f55, fArray2);
                                    JsonValue jsonValue24 = jsonValue22.next;
                                    if (jsonValue24 == null) break;
                                    float f56 = jsonValue24.getFloat("time", 0.0f);
                                    JsonValue jsonValue25 = jsonValue22.get("curve");
                                    if (jsonValue25 != null) {
                                        n25 = this.readCurve(jsonValue25, deformTimeline, n25, n24, 0, f55, f56, 0.0f, 1.0f, 1.0f);
                                    }
                                    f55 = f56;
                                    jsonValue22 = jsonValue24;
                                    ++n24;
                                }
                                deformTimeline.shrink(n25);
                                array.add(deformTimeline);
                                break;
                            }
                            case "sequence": {
                                Object object6 = new Animation.SequenceTimeline(n22, ((SlotData)object2).index, attachment);
                                float f57 = 0.0f;
                                int n31 = 0;
                                while (jsonValue22 != null) {
                                    float f58 = jsonValue22.getFloat("delay", f57);
                                    ((Animation.SequenceTimeline)object6).setFrame(n31, jsonValue22.getFloat("time", 0.0f), Sequence.SequenceMode.valueOf(jsonValue22.getString("mode", "hold")), jsonValue22.getInt("index", 0), f58);
                                    f57 = f58;
                                    jsonValue22 = jsonValue22.next;
                                    ++n31;
                                }
                                array.add((Animation.Timeline)object6);
                            }
                        }
                        jsonValue21 = jsonValue21.next;
                    }
                    jsonValue20 = jsonValue20.next;
                }
                jsonValue19 = jsonValue19.next;
            }
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.get("drawOrder");
        if (jsonValue3 != null) {
            Animation.DrawOrderTimeline drawOrderTimeline = new Animation.DrawOrderTimeline(jsonValue3.size);
            int n32 = skeletonData.slots.size;
            int n33 = 0;
            JsonValue jsonValue26 = jsonValue3.child;
            while (jsonValue26 != null) {
                int[] nArray = null;
                JsonValue jsonValue27 = jsonValue26.get("offsets");
                if (jsonValue27 != null) {
                    nArray = new int[n32];
                    for (int i = n32 - 1; i >= 0; --i) {
                        nArray[i] = -1;
                    }
                    int[] nArray2 = new int[n32 - jsonValue27.size];
                    int n34 = 0;
                    int n35 = 0;
                    JsonValue jsonValue28 = jsonValue27.child;
                    while (jsonValue28 != null) {
                        SlotData slotData = skeletonData.findSlot(jsonValue28.getString("slot"));
                        if (slotData == null) {
                            throw new SerializationException("Slot not found: " + jsonValue28.getString("slot"));
                        }
                        while (n34 != slotData.index) {
                            nArray2[n35++] = n34++;
                        }
                        nArray[n34 + jsonValue28.getInt((String)"offset")] = n34++;
                        jsonValue28 = jsonValue28.next;
                    }
                    while (n34 < n32) {
                        nArray2[n35++] = n34++;
                    }
                    for (int i = n32 - 1; i >= 0; --i) {
                        if (nArray[i] != -1) continue;
                        nArray[i] = nArray2[--n35];
                    }
                }
                drawOrderTimeline.setFrame(n33, jsonValue26.getFloat("time", 0.0f), nArray);
                jsonValue26 = jsonValue26.next;
                ++n33;
            }
            array.add(drawOrderTimeline);
        }
        if ((jsonValue2 = jsonValue.get("events")) != null) {
            Animation.EventTimeline eventTimeline = new Animation.EventTimeline(jsonValue2.size);
            int n36 = 0;
            JsonValue jsonValue29 = jsonValue2.child;
            while (jsonValue29 != null) {
                EventData eventData = skeletonData.findEvent(jsonValue29.getString("name"));
                if (eventData == null) {
                    throw new SerializationException("Event not found: " + jsonValue29.getString("name"));
                }
                Event event = new Event(jsonValue29.getFloat("time", 0.0f), eventData);
                event.intValue = jsonValue29.getInt("int", eventData.intValue);
                event.floatValue = jsonValue29.getFloat("float", eventData.floatValue);
                event.stringValue = jsonValue29.getString("string", eventData.stringValue);
                if (event.data.audioPath != null) {
                    event.volume = jsonValue29.getFloat("volume", eventData.volume);
                    event.balance = jsonValue29.getFloat("balance", eventData.balance);
                }
                eventTimeline.setFrame(n36, event);
                jsonValue29 = jsonValue29.next;
                ++n36;
            }
            array.add(eventTimeline);
        }
        array.shrink();
        float f59 = 0.0f;
        Animation.Timeline[] timelineArray = (Animation.Timeline[])array.items;
        int n37 = array.size;
        for (int i = 0; i < n37; ++i) {
            f59 = Math.max(f59, timelineArray[i].getDuration());
        }
        skeletonData.animations.add(new Animation(string, array, f59));
    }

    private void readTimeline(Array<Animation.Timeline> array, JsonValue jsonValue, Animation.CurveTimeline1 curveTimeline1, float f, float f2) {
        float f3 = jsonValue.getFloat("time", 0.0f);
        float f4 = jsonValue.getFloat("value", f) * f2;
        int n = 0;
        int n2 = 0;
        while (true) {
            curveTimeline1.setFrame(n, f3, f4);
            JsonValue jsonValue2 = jsonValue.next;
            if (jsonValue2 == null) {
                curveTimeline1.shrink(n2);
                array.add(curveTimeline1);
                return;
            }
            float f5 = jsonValue2.getFloat("time", 0.0f);
            float f6 = jsonValue2.getFloat("value", f) * f2;
            JsonValue jsonValue3 = jsonValue.get("curve");
            if (jsonValue3 != null) {
                n2 = this.readCurve(jsonValue3, curveTimeline1, n2, n, 0, f3, f5, f4, f6, f2);
            }
            f3 = f5;
            f4 = f6;
            jsonValue = jsonValue2;
            ++n;
        }
    }

    private void readTimeline(Array<Animation.Timeline> array, JsonValue jsonValue, Animation.BoneTimeline2 boneTimeline2, String string, String string2, float f, float f2) {
        float f3 = jsonValue.getFloat("time", 0.0f);
        float f4 = jsonValue.getFloat(string, f) * f2;
        float f5 = jsonValue.getFloat(string2, f) * f2;
        int n = 0;
        int n2 = 0;
        while (true) {
            boneTimeline2.setFrame(n, f3, f4, f5);
            JsonValue jsonValue2 = jsonValue.next;
            if (jsonValue2 == null) {
                boneTimeline2.shrink(n2);
                array.add(boneTimeline2);
                return;
            }
            float f6 = jsonValue2.getFloat("time", 0.0f);
            float f7 = jsonValue2.getFloat(string, f) * f2;
            float f8 = jsonValue2.getFloat(string2, f) * f2;
            JsonValue jsonValue3 = jsonValue.get("curve");
            if (jsonValue3 != null) {
                n2 = this.readCurve(jsonValue3, boneTimeline2, n2, n, 0, f3, f6, f4, f7, f2);
                n2 = this.readCurve(jsonValue3, boneTimeline2, n2, n, 1, f3, f6, f5, f8, f2);
            }
            f3 = f6;
            f4 = f7;
            f5 = f8;
            jsonValue = jsonValue2;
            ++n;
        }
    }

    int readCurve(JsonValue jsonValue, Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5) {
        if (jsonValue.isString()) {
            if (jsonValue.asString().equals("stepped")) {
                curveTimeline.setStepped(n2);
            }
            return n;
        }
        jsonValue = jsonValue.get(n3 << 2);
        float f6 = jsonValue.asFloat();
        jsonValue = jsonValue.next;
        float f7 = jsonValue.asFloat() * f5;
        jsonValue = jsonValue.next;
        float f8 = jsonValue.asFloat();
        jsonValue = jsonValue.next;
        float f9 = jsonValue.asFloat() * f5;
        SkeletonJson.setBezier(curveTimeline, n2, n3, n, f, f3, f6, f7, f8, f9, f2, f4);
        return n + 1;
    }

    static void setBezier(Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        curveTimeline.setBezier(n3, n, n2, f, f2, f3, f4, f5, f6, f7, f8);
    }

    static class LinkedMesh {
        String parent;
        String skin;
        int slotIndex;
        MeshAttachment mesh;
        boolean inheritTimelines;

        public LinkedMesh(MeshAttachment meshAttachment, String string, int n, String string2, boolean bl) {
            this.mesh = meshAttachment;
            this.skin = string;
            this.slotIndex = n;
            this.parent = string2;
            this.inheritTimelines = bl;
        }
    }
}

