/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import java.io.Serializable;

public final class Affine2
implements Serializable {
    public float m00 = 1.0f;
    public float m01 = 0.0f;
    public float m02 = 0.0f;
    public float m10 = 0.0f;
    public float m11 = 1.0f;
    public float m12 = 0.0f;

    public Affine2 setToTrnRotScl(float x, float y, float degrees, float scaleX, float scaleY) {
        this.m02 = x;
        this.m12 = y;
        if (degrees == 0.0f) {
            this.m00 = scaleX;
            this.m01 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = scaleY;
        } else {
            float sin = MathUtils.sinDeg(degrees);
            float cos = MathUtils.cosDeg(degrees);
            this.m00 = cos * scaleX;
            this.m01 = -sin * scaleY;
            this.m10 = sin * scaleX;
            this.m11 = cos * scaleY;
        }
        return this;
    }

    public Affine2 preMul(Affine2 other) {
        float tmp00 = other.m00 * this.m00 + other.m01 * this.m10;
        float tmp01 = other.m00 * this.m01 + other.m01 * this.m11;
        float tmp02 = other.m00 * this.m02 + other.m01 * this.m12 + other.m02;
        float tmp10 = other.m10 * this.m00 + other.m11 * this.m10;
        float tmp11 = other.m10 * this.m01 + other.m11 * this.m11;
        float tmp12 = other.m10 * this.m02 + other.m11 * this.m12 + other.m12;
        this.m00 = tmp00;
        this.m01 = tmp01;
        this.m02 = tmp02;
        this.m10 = tmp10;
        this.m11 = tmp11;
        this.m12 = tmp12;
        return this;
    }

    public Affine2 translate(float x, float y) {
        this.m02 += this.m00 * x + this.m01 * y;
        this.m12 += this.m10 * x + this.m11 * y;
        return this;
    }

    public String toString() {
        return "[" + this.m00 + "|" + this.m01 + "|" + this.m02 + "]\n[" + this.m10 + "|" + this.m11 + "|" + this.m12 + "]\n[0.0|0.0|0.1]";
    }
}

