/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.utils.GdxRuntimeException;

public class OpenALUtils {
    static int determineFormat(int channels, int bitDepth) {
        int format = switch (channels) {
            case 1 -> {
                switch (bitDepth) {
                    case 8: {
                        yield 4352;
                    }
                    case 16: {
                        yield 4353;
                    }
                    case 32: {
                        yield 65552;
                    }
                    case 64: {
                        yield 65554;
                    }
                }
                throw new GdxRuntimeException("Audio: Bit depth must be 8, 16, 32 or 64.");
            }
            case 2 -> {
                switch (bitDepth) {
                    case 8: {
                        yield 4354;
                    }
                    case 16: {
                        yield 4355;
                    }
                    case 32: {
                        yield 65553;
                    }
                    case 64: {
                        yield 65555;
                    }
                }
                throw new GdxRuntimeException("Audio: Bit depth must be 8, 16, 32 or 64.");
            }
            case 4 -> 4613;
            case 6 -> 4619;
            case 7 -> 4622;
            case 8 -> 4625;
            default -> throw new GdxRuntimeException("Audio: Invalid number of channels. Must be mono, stereo, quad, 5.1, 6.1 or 7.1.");
        };
        if (channels >= 4) {
            if (bitDepth == 8) {
                --format;
            } else if (bitDepth == 32) {
                ++format;
            } else if (bitDepth != 16) {
                throw new GdxRuntimeException("Audio: Bit depth must be 8, 16 or 32 when 4+ channels are present.");
            }
        }
        return format;
    }
}

