/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALLwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALUtils;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.openal.AL10;

public class OpenALSound
implements Sound {
    private int bufferID = -1;
    private final OpenALLwjgl3Audio audio;
    private float duration;
    private int sampleRate;
    private int channels;
    private String type;

    public OpenALSound(OpenALLwjgl3Audio audio) {
        this.audio = audio;
    }

    void setup(byte[] pcm, int channels, int bitDepth, int sampleRate) {
        int validBytes = pcm.length - pcm.length % (channels * (bitDepth >> 3));
        ByteBuffer buffer = BufferUtils.newByteBuffer(validBytes);
        buffer.put(pcm, 0, validBytes);
        ((Buffer)buffer).flip();
        this.setup(buffer.asShortBuffer(), channels, bitDepth, sampleRate);
    }

    void setup(ShortBuffer pcm, int channels, int bitDepth, int sampleRate) {
        this.channels = channels;
        this.sampleRate = sampleRate;
        int sampleFrames = (pcm.limit() << 1) / (bitDepth >> 3) / channels;
        this.duration = (float)sampleFrames / (float)sampleRate;
        if (this.bufferID == -1) {
            this.bufferID = AL10.alGenBuffers();
            int format = OpenALUtils.determineFormat(channels, bitDepth);
            AL10.alBufferData((int)this.bufferID, (int)format, (ShortBuffer)pcm, (int)sampleRate);
        }
    }

    @Override
    public void dispose() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.bufferID == -1) {
            return;
        }
        this.audio.freeBuffer(this.bufferID);
        AL10.alDeleteBuffers((int)this.bufferID);
        this.bufferID = -1;
        this.audio.forget(this);
    }

    public void setType(String type) {
        this.type = type;
    }
}

