/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class Lwjgl3Cursor
implements Cursor {
    static final Array<Lwjgl3Cursor> cursors = new Array();
    static final Map<Object, Long> systemCursors = new HashMap<Object, Long>();
    private static int inputModeBeforeNoneCursor = -1;
    final Lwjgl3Window window;
    Pixmap pixmapCopy;
    GLFWImage glfwImage;
    final long glfwCursor;

    @Override
    public void dispose() {
        if (this.pixmapCopy == null) {
            throw new GdxRuntimeException("Cursor already disposed");
        }
        cursors.removeValue(this, true);
        this.pixmapCopy.dispose();
        this.pixmapCopy = null;
        this.glfwImage.free();
        GLFW.glfwDestroyCursor(this.glfwCursor);
    }

    static void dispose(Lwjgl3Window window) {
        for (int i = Lwjgl3Cursor.cursors.size - 1; i >= 0; --i) {
            Lwjgl3Cursor cursor = cursors.get(i);
            if (!cursor.window.equals(window)) continue;
            cursors.removeIndex(i).dispose();
        }
    }

    static void disposeSystemCursors() {
        for (long systemCursor : systemCursors.values()) {
            GLFW.glfwDestroyCursor(systemCursor);
        }
        systemCursors.clear();
    }
}

